<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="X-UA-Compatible" content="ie=edge">
<title>Brisbane Food Trucks</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
<!-- Links page to the bootstrap css stylesheet-->
 
<style>
  /* Add some basic styling to the table */
  .data-table {
    width: 100%;
    border-collapse: collapse;
  }
  .data-table th, .data-table td {
    border: 1px solid #ddd;
    padding: 8px;
    text-align: left;
  }
  .data-table th {
    background-color: #f2f2f2;
  }
</style>
</head>
<body>
   
<div class="container">
<h1 class="text-center mt-4">Food Trucks</h1>
<div class="container m-auto">
    
    <div class="filters">
    <h2>Filter by category</h2>
    <form id="filter-form">
      <h3>Check filter required</h3>
      <div class="category-filters">
        <label><input class="category-filter" type="radio" name="filter" value="category">Category</label>
        <label><input class="name-filter" type="radio" name="filter" value="name">Truck Name</label>
      </div>
    </form>
  </div>
   <div id = 'data-container'></div>
  
  </br>
  
<?php
$data_src = 'https://www.bnefoodtrucks.com.au/api/1/trucks';
//A variable is set to contain the URL for the truck data JSON file
$request = curl_init($data_src);
//Initiallizes the cURL session
curl_setopt($request, CURLOPT_RETURNTRANSFER, TRUE);
//Sets an option so that resulting data is returned as a string
curl_setopt($request, CURLOPT_SSL_VERIFYPEER, FALSE);
//Sets an option to disable a liscence check, which results in the process failing if enabled due to the URL source being a https link
$result = curl_exec($request);
//Performs the cURL session
curl_close($request);
//Closes the session now that the data has been retrieved
$data_truck = json_decode($result, true);
//Decodes the resulting JSON from the cURL session and sets it to a variable for later use
echo '<div class="row justify-content-center">';
foreach ($data_truck as $truck) {
//Loops through each truck object within $data_truck, where the name, category, and logo are output within a bootstrap card div
echo '<div class="card" style="width: 12rem;">';
echo '<h3>'.$truck['name'].'</h3>';
echo '<h5>'.$truck['category'].'</h5>';

echo '<img src="'.$truck['avatar']['src'].'" height="64" width="64">';
echo '</div>';
}
echo '</div>';
?>
</div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
<!-- Links page to the Bootstrap JavaScript-->
<script src="code2.js"></script>
</body>
</html>